# Written by Fred Hoyt, 2007-2012

############
# Overview #
############
#
# This script is for use with the Praat acoustic analysis program
#
# http://www.fon.hum.uva.nl/praat/
#
# The Praat scripting language is detailed here:
#
# http://www.fon.hum.uva.nl/praat/manual/Scripting.html
#
# It is intended to be used with the "get_ldc_data.py" script
# which calls it. It takes 7 arguments: 
#
# arg1 = the extension of the output audio file
# arg2 = file name (without extension)
# arg3 = start of time stamp (in format NN.NN)
# arg4 = end of time stamp (in format NN.NN)
# arg5 = speaker tag (A or B)
# arg6 = speaker metadata
# arg7 = datum string
#
# Note on Syntax: Praat variables are wrapped in single quotes 
# and suffixed with $. 

##########
# Script #
##########

# define sequence of variables based on input arguments
form Extract sequence
	text ext # arg1
	text name # arg2
	real start_point # arg3
	real end_point # arg4
	text speaker # arg5
	text info # arg6
	text data # arg7
endform

# Open and select audio file in .wav format
Open long sound file... 'name$'.'ext$'

# Excise segment of audio file corresponding to time stamp
# as a "sound" in Praat
Extract part... start_point end_point yes

#define variable for beginning of time stamp
start$ = "'start_point'" 

# define variable for end of time stamp
end$ = "'end_point'" 

# define variable for name of output
# which is a concatenation of the file name,
# its time stamp, speaker tag
# and speaker metadata
newname$ = name$ + "_" + start$ + "-" + end$ + "_" + speaker$ + "_" + info$

# Select excised segment
select Sound 'name$'

# Copy input text to Text Grid
To TextGrid... "Input" 

# Select excised segment (again?)

# Resample sound at 44000Hz: Praat is 
# particular about sampling rates
select Sound 'name$'
Resample... 44000 50
select Sound 'name$'
Remove

# Select data text
select TextGrid 'name$'

# Synchronize data text with audio
Set interval text... 1 1 'data$'
plus Sound 'name$'_44000

# Write to file again
Write to text file... 'newname$'.Collection

